(function ($) {
	"use strict";

	var $window = $(window);
	var $body = $('body');

	/* Preloader Effect */
	$window.on('load', function () {
		$(".preloader").fadeOut(600);
	});

	/* Sticky Header */
	if ($('.active-sticky-header').length) {
		$window.on('resize', function () {
			setHeaderHeight();
		});

		function setHeaderHeight() {
			$("header.main-header").css("height", $('header .header-sticky').outerHeight());
		}

		$window.on("scroll", function () {
			var fromTop = $(window).scrollTop();
			setHeaderHeight();
			var headerHeight = $('header .header-sticky').outerHeight()
			$("header .header-sticky").toggleClass("hide", (fromTop > headerHeight + 100));
			$("header .header-sticky").toggleClass("active", (fromTop > 600));
		});
	}

	/* Slick Menu JS */
	$('#menu').slicknav({
		label: '',
		prependTo: '.responsive-menu'
	});

	if ($("a[href='#top']").length) {
		$(document).on("click", "a[href='#top']", function () {
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});
	}

	/* Hero Slider Layout JS */
	const hero_slider_layout = new Swiper('.hero-slider-layout .swiper', {
		slidesPerView: 1,
		speed: 1000,
		spaceBetween: 0,
		loop: true,
		autoplay: {
			delay: 4000,
		},
		pagination: {
			el: '.hero-pagination',
			clickable: true,
		},
	});

	/* testimonial Slider JS */
	if ($('.testimonial-slider').length) {
		const testimonial_slider = new Swiper('.testimonial-slider .swiper', {
			slidesPerView: 1,
			speed: 1000,
			spaceBetween: 30,
			loop: true,
			autoplay: {
				delay: 3000,
			},
			pagination: {
				el: '.swiper-pagination',
				clickable: true,
			},
			navigation: {
				nextEl: '.testimonial-btn-next',
				prevEl: '.testimonial-btn-prev',
			},
			breakpoints: {
				768: {
					slidesPerView: 2,
				},
				991: {
					slidesPerView: 3,
				}
			}
		});
	}
/* Certifications Slider JS */
if ($('.certification-slider').length) {
    const certification_slider = new Swiper('.certification-slider', {
        slidesPerView: 1,
        speed: 5000,
        spaceBetween: 30,
        loop: true,
        autoplay: {
            delay: 0, // No delay for continuous movement
            disableOnInteraction: false,
        },
        navigation: {
            nextEl: '.certification-btn-next',
            prevEl: '.certification-btn-prev',
        },
        breakpoints: {
            576: {
                slidesPerView: 2,
            },
            768: {
                slidesPerView: 3,
            },
            992: {
                slidesPerView: 4,
            },
            1200: {
                slidesPerView: 5,
            }
        }
    });
}

/* testimonial Slider JS */
if ($('.testimonial-slider').length) {
    const testimonial_slider = new Swiper('.testimonial-slider .swiper', {
        // existing testimonial slider configuration
    });
}

	/* Skill Bar */
	if ($('.skills-progress-bar').length) {
		$('.skills-progress-bar').waypoint(function () {
			$('.skillbar').each(function () {
				$(this).find('.count-bar').animate({
					width: $(this).attr('data-percent')
				}, 2000);
			});
		}, {
			offset: '50%'
		});
	}

	/* Youtube Background Video JS */
	if ($('#herovideo').length) {
		var myPlayer = $("#herovideo").YTPlayer();
	}

	/* Init Counter */
	if ($('.counter').length) {
		$('.counter').counterUp({ delay: 6, time: 2000 });
	}

	/* Image Reveal Animation */
	if ($('.reveal').length) {
		gsap.registerPlugin(ScrollTrigger);
		let revealContainers = document.querySelectorAll(".reveal");
		revealContainers.forEach((container) => {
			let image = container.querySelector("img");
			let tl = gsap.timeline({
				scrollTrigger: {
					trigger: container,
					toggleActions: "play none none none"
				}
			});
			tl.set(container, {
				autoAlpha: 1
			});
			tl.from(container, 1, {
				xPercent: -100,
				ease: Power2.out
			});
			tl.from(image, 1, {
				xPercent: 100,
				scale: 1,
				delay: -1,
				ease: Power2.out
			});
		});
	}

	/* Text Effect Animation */
	if ($('.text-anime-style-1').length) {
		let staggerAmount = 0.05,
			translateXValue = 0,
			delayValue = 0.5,
			animatedTextElements = document.querySelectorAll('.text-anime-style-1');

		animatedTextElements.forEach((element) => {
			let animationSplitText = new SplitText(element, { type: "chars, words" });
			gsap.from(animationSplitText.words, {
				duration: 1,
				delay: delayValue,
				x: 20,
				autoAlpha: 0,
				stagger: staggerAmount,
				scrollTrigger: { trigger: element, start: "top 85%" },
			});
		});
	}

	if ($('.text-anime-style-2').length) {
		let staggerAmount = 0.03,
			translateXValue = 20,
			delayValue = 0.1,
			easeType = "power2.out",
			animatedTextElements = document.querySelectorAll('.text-anime-style-2');

		animatedTextElements.forEach((element) => {
			let animationSplitText = new SplitText(element, { type: "chars, words" });
			gsap.from(animationSplitText.chars, {
				duration: 1,
				delay: delayValue,
				x: translateXValue,
				autoAlpha: 0,
				stagger: staggerAmount,
				ease: easeType,
				scrollTrigger: { trigger: element, start: "top 85%" },
			});
		});
	}

	if ($('.text-anime-style-3').length) {
		let animatedTextElements = document.querySelectorAll('.text-anime-style-3');

		animatedTextElements.forEach((element) => {
			//Reset if needed
			if (element.animation) {
				element.animation.progress(1).kill();
				element.split.revert();
			}

			element.split = new SplitText(element, {
				type: "lines,words,chars",
				linesClass: "split-line",
			});
			gsap.set(element, { perspective: 400 });

			gsap.set(element.split.chars, {
				opacity: 0,
				x: "50",
			});

			element.animation = gsap.to(element.split.chars, {
				scrollTrigger: { trigger: element, start: "top 90%" },
				x: "0",
				y: "0",
				rotateX: "0",
				opacity: 1,
				duration: 1,
				ease: Back.easeOut,
				stagger: 0.02,
			});
		});
	}

	/* Parallaxie js */
	/* var $parallaxie = $('.parallaxie');
	if($parallaxie.length && ($window.width() > 991))
	{
		if ($window.width() > 768) {
			$parallaxie.parallaxie({
				speed: 0.55,
				offset: 0,
			});
		}
	} */

	/* Zoom Gallery screenshot */
	$('.gallery-items').magnificPopup({
		delegate: 'a',
		type: 'image',
		closeOnContentClick: false,
		closeBtnInside: false,
		mainClass: 'mfp-with-zoom',
		image: {
			verticalFit: true,
		},
		gallery: {
			enabled: true
		},
		zoom: {
			enabled: true,
			duration: 300, // don't foget to change the duration also in CSS
			opener: function (element) {
				return element.find('img');
			}
		}
	});

	/* Contact form validation */
	// var $contactform = $("#contactForm");
	// $contactform.validator({ focus: false }).on("submit", function (event) {
	// 	if (!event.isDefaultPrevented()) {
	// 		event.preventDefault();
	// 		submitForm();
	// 	}
	// });

	// function submitForm() {
	// 	/* Ajax call to submit form */
	// 	$.ajax({
	// 		type: "POST",
	// 		url: "form-process.php",
	// 		data: $contactform.serialize(),
	// 		success: function (text) {
	// 			if (text === "success") {
	// 				formSuccess();
	// 			} else {
	// 				submitMSG(false, text);
	// 			}
	// 		}
	// 	});
	// }

	// function formSuccess() {
	// 	$contactform[0].reset();
	// 	submitMSG(true, "Message Sent Successfully!")
	// }

	// function submitMSG(valid, msg) {
	// 	if (valid) {
	// 		var msgClasses = "h4 text-success";
	// 	} else {
	// 		var msgClasses = "h4 text-danger";
	// 	}
	// 	$("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
	// }
	/* Contact form validation end */

	/* Appointment form validation */
	// var $appointmentForm = $("#appointmentForm");
	// $appointmentForm.validator({ focus: false }).on("submit", function (event) {
	// 	if (!event.isDefaultPrevented()) {
	// 		event.preventDefault();
	// 		submitappointmentForm();
	// 	}
	// });

	// function submitappointmentForm() {
	// 	/* Ajax call to submit form */
	// 	$.ajax({
	// 		type: "POST",
	// 		url: "form-appointment.php",
	// 		data: $appointmentForm.serialize(),
	// 		success: function (text) {
	// 			if (text === "success") {
	// 				appointmentformSuccess();
	// 			} else {
	// 				appointmentsubmitMSG(false, text);
	// 			}
	// 		}
	// 	});
	// }

	// function appointmentformSuccess() {
	// 	$appointmentForm[0].reset();
	// 	appointmentsubmitMSG(true, "Message Sent Successfully!")
	// }

	// function appointmentsubmitMSG(valid, msg) {
	// 	if (valid) {
	// 		var msgClasses = "h3 text-success";
	// 	} else {
	// 		var msgClasses = "h3 text-danger";
	// 	}
	// 	$("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
	// }
	/* Appointment form validation end */

	/* Case Study (filtering) Start */
	$window.on("load", function () {
		if ($(".case-study-item-boxes").length) {

			/* Init Isotope */
			var $menuitem = $(".case-study-item-boxes").isotope({
				itemSelector: ".case-study-item-box",
				layoutMode: "masonry",
				masonry: {
					// use outer width of grid-sizer for columnWidth
					columnWidth: 1,
				}
			});

			/* Filter items on click */
			var $menudisesnav = $(".case-study-nav li a");
			$menudisesnav.on('click', function (e) {

				var filterValue = $(this).attr('data-filter');
				$menuitem.isotope({
					filter: filterValue
				});

				$menudisesnav.removeClass("active-btn");
				$(this).addClass("active-btn");
				e.preventDefault();
			});
			$menuitem.isotope({ filter: "*" });
		}
	});
	/* Case Study (filtering) End */

	/* Animated Wow Js */
	new WOW().init();

	/* Popup Video */
	if ($('.popup-video').length) {
		$('.popup-video').magnificPopup({
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: true
		});
	}

})(jQuery);



// NavbarSticky Js Function By uzair
let lastScrollTop = 0;
const navbar = document.querySelector('header');

window.addEventListener('scroll', function () {
	let scrollTop = window.pageYOffset || document.documentElement.scrollTop;

	if (scrollTop > lastScrollTop) {
		navbar.classList.remove('navbar-hidden');
	} else {
		navbar.classList.add('navbar-hidden');
	}
	lastScrollTop = scrollTop <= 0 ? 0 : scrollTop;
});